--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--
--Action.AddCampFlag(flag-n, number)														--
--Action.AddImage("filname.jpg")															--
--Action.CampaignEnd("win"/"draw"/"loss")													--
--Action.TargetActive("TargetName", boolean)												--
--Action.AirUnitActive("UnitName", boolean)													--
--Action.AirUnitBase("UnitName", "BaseName")												--
--Action.AirUnitPlayer("UnitName", boolean)													--
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--
--Action.AirUnitRepair()																	--
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--
--Action.GroupHidden("GroupName", boolean)													--
--Action.GroupProbability("GroupName", number 0-1)											--
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			'Action.Text("April 1983, after our first victorious attack against Iran in 1980 the 22nd of september, our army was not able to move anymore. The frontline is stabilized and our Air Force mission is now to destroy iranian industrial sites, to reduce Islamic Republic of Iran Air Force strength and to attack the enemy troops all along and back to the frontline.")',
			'Action.Text("Our Air Force have considerable forces. Our main fighters are Mig-21 and Mig-23. The strike missions are made by Su-17 and Mig-23. We are hoping that Russian Mig-25 will be able to avoid mighty Iranian F-14 interceptions relying on their speed but we are waiting for them impatiently. We will soon be able to use french Mirage F1 EQ to attack ships and ground targets with better accuracy. Interceptor fighters are directed by ground based early warning radar and various SAMs are protecting the cities, the bases and the frontline. There are mainly SA-3 and SA-2 and short range SA-9 and manpads. Shilka and old 23mm twin guns are our main AAA forces")',
			'Action.Text("The Islamic Republic of Iran Air Force is flying a mix of F-14A, F-4E and F-5E-3 fighters directed by ground based early warning radar. Air bases and target complexes of high value are protected by west surface-air missile systems, such as the Hawk system and the Rapier, as well as short-range AAA.")',
			'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
		},
	},
	
----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 30 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 70',
		action = {
			'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 35 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 65',
		action = {
			'Action.Text("More than a third of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},
	["Campaign Red first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 100',
		action = {
			'Action.Text("The enemy destroyed its first allied targets, you must defend them.")',
		},
	},
	["Campaign Red 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 80',
		action = {
			'Action.Text("The enemy destroyed nearly 20 percents of allied targets, you must defend them.")',
		},
	},
	["Campaign Red 30 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 70',
		action = {
			'Action.Text("Allies troops have sustained great damages. Enemy strike missions are too efficient and they will win this war soon")',
		},
	},
	["Campaign Red 45 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 55',
		action = {
			'Action.Text("Too much allied troops are neutralized. We will ask for a cease fire soon")',
		},
	},
	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = false,
		condition = 'GroundTarget["red"].percent < 60',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("Irakian Air Force have successfully destroyed enough Iranian forces to allow futur ground offensive. Irakian air power has once again proven its effectiveness and decisiveness. Well done.")',
			'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.totalAirUnitAliveBySide("red") < 10',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("The Islamic Republic Iranian Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Iranians are no longer able to produce any sorties or offer any resistance. The Irakian air force now owns complete air superiority. We will launch a new decisive attack on the frontline soon. Well done.")',
			'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("14th Squadron") < 2',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Ongoing combat operations have exhausted your squadron. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Iraki Air Force to attain air superiority, Iranian forces will certainly try to launch a new decisive attack on the frontline. It s a bitter defeat for us")',
			'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 50',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Iranian Air Force have successfully destroyed enough Irakian forces to stop any a new offensive of our ground forces. Irakian air power was not efficient enough to stop Iranian Air Forces. This is a bitter failure.")',
			'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 60',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Islamic Republic Iranian Air Force and infrastructure, Iraqi Central Command has called off all squadrons from offensive operations. We hope we will be able to launch new attacks to repulse Iraqi invader soon.")',
			[3] = 'NoMoreNewspaper = true',
		},
	},


		
	----- BLUE CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR-1") == 0 and Return.TargetAlive("EWR-2") == 0 and Return.TargetAlive("EWR-3") == 0',
		action = {
			[1] = 'Action.TargetActive("CAP Larak", true)',
			[2] = 'Action.TargetActive("CAP Frontline", true)',
			[3] = 'Action.TargetActive("Lar Airbase 250 Km", false)',
			[4] = 'Action.TargetActive("Shiraz Intl 250 Km", false)',
			[5] = 'Action.TargetActive("Bandar Abbas Intl 150 Km", false)',
			[6] = 'Action.TargetActive("Havadarya Alert", false)',
			[7] = 'Action.Text("With the recent destruction of all our Early Warning Radar sites in the operations area, Iranian ability to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will have to increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},

	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR 1") == 0 and Return.TargetAlive("EWR 2") == 0 and Return.TargetAlive("EWR 3") == 0',
		action = {
			[1] = 'Action.TargetActive("Dubai Intl Alert", false)',
			[2] = 'Action.TargetActive("Al Dhafra AB Alert", false)',
			[3] = 'Action.TargetActive("Sharjah Intl Alert", false)',
			[4] = 'Action.TargetActive("Al Maktoum Intl Alert", false)',
			[5] = 'Action.Text("With the recent destruction of all our Early Warning Radar sites in the operations area, our ability to launch interceptors against Iranian strike packages was severely degraded. We will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},		
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	
	
	
		----- UNIT ACTIVATION -----
	["Unit Activate Mig-25RBT"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 10',
		action = {
			'Action.AirUnitActive("83 Squadron", true)',
			'Action.AirUnitBase("83 Squadron", "Al Dhafra AFB")',
			'Action.Text("Russians new Mig-25 has deployed in Iraq. Their main missions will be Reconnaissance and high altitude bombing")',
			'Action.TargetActive("Recon Frontline", true)',
			'Action.TargetActive("Recon Bandar Abas Airbase", true)',
			'Action.TargetActive("Recon navigation lines", true)',			
		},
	},
	["Unit Activate MiG-27K"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			'Action.AirUnitActive("300 IAP", true)',
			'Action.AirUnitBase("300 IAP", "Dubai Intl")',
			'Action.Text("A russian squadron of Mig-27 fighter has deployed. These Mig are equipped with Air to ground and ARM missiles. They will be priority targets for enemy fighters")',
		},
	},
	["Unit Activate MiG-25"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 5',
		action = {
			'Action.AirUnitActive("23 Squadron", true)',
			'Action.AirUnitBase("23 Squadron", "Al Dhafra AFB")',
			'Action.Text("Russian MiG-25 Foxbat interceptors are operationnal now. While the operational readiness of the aircraft is still low, this mach 3 interceptor is flown by the elite of the pilot cadre and should poses a serious threat to enemy strike missions.")',
			'Action.AddImage("Recon_MiG-25_1.jpg")',
			'Action.AddImage("Recon_MiG-25_2.jpg")',
		},
	},

----------------------------  TANKER CONVOYS    -----------------------------------------------------

["Iranian Tanker convoy 3"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
		[1] = 'Action.TemplateActive("Iranian Tanker convoy 3.stm")',
		[2] = 'Action.TargetActive("Iranian Tanker convoy 3", true)',
		[3] = 'Action.ShipMission("Iranian Tanker convoy 3", {{"Iranian Tanker convoy 3-1", "Iranian Tanker convoy 3-2", "Iranian Tanker convoy 3-3", "Iranian Tanker convoy 3-4", "Iranian Tanker convoy 3-5", "Iranian Tanker convoy 3-6"}}, 8, 5, nil)',
		[4] = 'Action.Text("Iranian Tankers convoys must be targeted by our bombers to stop iranian oil exportations")',
		},
	},

["Iranian Tanker convoy 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
		[1] = 'Action.TemplateActive("Iranian Tanker convoy 2.stm")',
		[2] = 'Action.TargetActive("Iranian Tanker convoy 2", true)',
		[3] = 'Action.ShipMission("Iranian Tanker convoy 2", {{"Iranian Tanker convoy 2-1", "Iranian Tanker convoy 2-2", "Iranian Tanker convoy 2-3", "Iranian Tanker convoy 2-4", "Iranian Tanker convoy 2-5", "Iranian Tanker convoy 2-6"}}, 8, 5, nil)',
		[4] = 'Action.Text("Iranian Tankers convoys must be targeted by our bombers to stop iranian oil exportations")',
		},
	},
	
["Iranian Tanker convoy 1"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 10',
		action = {
		[1] = 'Action.TemplateActive("Iranian Tanker convoy 1.stm")',
		[2] = 'Action.TargetActive("Iranian Tanker convoy 1", true)',
		[3] = 'Action.ShipMission("Iranian Tanker convoy 1", {{"Iranian Tanker convoy 1-1", "Iranian Tanker convoy 1-2", "Iranian Tanker convoy 1-3", "Iranian Tanker convoy 1-4", "Iranian Tanker convoy 1-5", "Iranian Tanker convoy 1-6"}}, 8, 5, nil)',
		[4] = 'Action.Text("Iranian Tankers convoys must be targeted by our bombers to stop iranian oil exportations")',
		},
	},

	

	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
}




